

#### Odabrane teme primijenjene ekonometrije: Linearni regresijski model ####


#################################################################################
# Instalirati sljedece pakete prije provodenja naredbi (ako prvi puta radite u R-u):

paketi<-c("car","dummies","dynlm","devEMF","lmtest","lmSupport","Matrix","matrixStats",
          "Deriv","moments","normtest","quantmod","QuantPsyc","tseries","urca","vars",
          "xlsx","stats","stats4","forecast","readxl","gap","strucchange","sandwich")

install.packages(paketi,dependencies = T)

# Napomena: Kada se prvi puta instaliraju svi paketi zajedno, instalacija traje dulje vrijeme.
# U izradi ove skripte koritena je verzija R - 3.6.2 i RStudio "Orange blossom"
# Skripta je testirana i objavljena u veljai 2023.

#################################################################################


setwd("~/__R datoteke LRM")

#################################################################################
# POGLAVLJE 1
#################################################################################


#Slika 1.1.

#ucitavanje podataka i definiranje vremenskih nizova:
library(readxl)
library(devEMF)
BDP_hrvatske <- read_excel("BDP hrvatske.xlsx")
BDP<-ts(BDP_hrvatske$`BDP (tekuce cijene, mil E)`,start=c(2010),frequency = 1)
log_BDP<-log(BDP)

#crtanje 2 slike, u jednom retku i 2 stupca:
par(mfrow=c(1,2),mar=c(2,4,2,2))
par(las=1)
plot(BDP)
plot(log_BDP)
# Emf (extended meta file) je vektorski format grafa, pogodan za izvoz u Word ili PDF dokumente.
emf("Slika 1.1. Usporedba BDP-a Hrvatske u razinama, te logaritmirane vrijednosti.emf")
par(mfrow=c(1,2),mar=c(2,4,2,2))
par(las=1)
plot(BDP)
plot(log_BDP)
dev.off() 
#################################################################################

#Slika 1.2.

#definiranje nizova:
x<-seq(1,500,1)
epsilon<-rnorm(500,0,1)
y<-2+0.5*x+epsilon

#crtanje slike, plot za ekranski prikaz, emf za izvoz u Word ili PDF dokument:
par(mfrow = c(1, 1),mar=c(4,4,1,1))
plot(x,y,cex=0.5,col="grey",ylab="Y",xlab="X")
abline(2,0.5)
emf("Slika 1.2. Dijagram rasipanja izmeu varijabli x i y, jaka pozitivna linearna veza.emf")
par(mfrow = c(1, 1),mar=c(4,4,1,1))
plot(x,y,cex=0.5,col="grey",ylab="Y",xlab="X")
abline(2,0.5)
dev.off() 

#################################################################################

#Slika 1.3.

#definiranje nizova:
x<-seq(1,500,1)
epsilon2<-rnorm(500,0,50)
y2<-2+0.5*x+epsilon2

#crtanje slike, plot za ekranski prikaz, emf za izvoz u Word ili PDF dokument:
plot(x,y2,cex=0.5,ylab="Y",xlab="X")
abline(2,0.5)
emf("Slika 1.3. Dijagram rasipanja izmeu varijabli x i y, umjerena pozitivna linearna veza.emf")
plot(x,y2,cex=0.5,ylab="Y",xlab="X")
abline(2,0.5)
dev.off()
#################################################################################


#Slika 1.4.

#definiranje nizova:
x<-seq(1,500,1)
y3<-(0.005)*x^2+epsilon2

#crtanje slike, plot za ekranski prikaz, emf za izvoz u Word ili PDF dokument:
plot(x,y3,cex=0.5,col="grey",ylab="Y",xlab="X")
abline(lm(y3~x),lty="dashed")
lines(fitted(lm(y3~0+I(x^2))))
emf("Slika 1.4. Dijagram rasipanja izmeu varijabli x i y, parabolina veza.emf")
plot(x,y3,cex=0.5,col="grey",ylab="Y",xlab="X")
abline(lm(y3~x),lty="dashed")
lines(fitted(lm(y3~0+I(x^2))))
dev.off()
#################################################################################

#Slika 1.5.

#definiranje nizova:
x<-seq(1,500,1)
y4<-rnorm(500,0,1)

#crtanje slike:
plot(x,y4,cex=0.5,ylab="Y",xlab="X")
emf("Slika 1.5. Dijagram rasipanja izmeu varijabli x i y, ne postoji veza.emf")
plot(x,y4,cex=0.5,ylab="Y",xlab="X") 
dev.off()
#################################################################################

#Primjer 1.5.

getwd()
podaci<-read.table("BDP_i_HICP.txt",header=T, sep="\t")

y<-podaci$GDP
x<-podaci$HICP

#Slika 1.10.

par(mfrow=c(1,1),mar=c(4,5,1,1))
plot(x,y)
emf("Slika 1.10. Dijagram rasipanja izmeu HICP-a (x) i BDP-a (y).emf")
par(mfrow=c(1,1),mar=c(4,5,1,1))
plot(x,y)
dev.off()
#################################################################################

#1.5. Pitanja za ponavljanje, 8 zadatak:

library(readxl)
makro_varijable <- read_excel("makro varijable.xls")

cijena<-makro_varijable$NAFTA
M1<-makro_varijable$M1

#slika lijevi panel
plot(M1,cijena)
abline(lm(cijena~M1))
emf("Dijagram rasipanja za monetarni agregat M1 i cijenu nafte, lijevi panel.emf")
plot(M1,cijena)
abline(lm(cijena~M1))
dev.off()
#slika desni panel
plot(M1,cijena)
kvadrat<-lm(cijena~M1+I(M1^2))
b<-M1
for(i in 1:length(cijena))
{b[i]<-kvadrat[["coefficients"]][1]+kvadrat[["coefficients"]][2]*M1[i]+kvadrat[["coefficients"]][3]*(M1[i]^2)
}
points(M1,b, type="l")
emf("Dijagram rasipanja za monetarni agregat M1 i cijenu nafte, desni panel.emf")
plot(M1,cijena)
kvadrat<-lm(cijena~M1+I(M1^2))
b<-M1
for(i in 1:length(cijena))
{b[i]<-kvadrat[["coefficients"]][1]+kvadrat[["coefficients"]][2]*M1[i]+kvadrat[["coefficients"]][3]*(M1[i]^2)
}
points(M1,b, type="l")
dev.off()
#slika treci panel (IIP i K stopa)

IIP<-makro_varijable$IIP
kamatna_stopa<-makro_varijable$kamatna_stopa

plot(kamatna_stopa,IIP)
emf("Dijagram rasipanja za indeks industrijske proizvodnje (IP) i kamatnu stopu.emf")
plot(kamatna_stopa,IIP)
dev.off()
#Crobex slika

library(readxl)
crobex <- read_excel("crobex.xlsx")
crobex_t<-crobex$crobex
crobex_t_1<-c(NA,crobex_t[-1225])

plot(crobex_t_1,crobex_t)

emf("Dijagram rasipanja za indeks CROBEX u mjesecu t i t-1.emf")
plot(crobex_t_1,crobex_t)
dev.off()

#1.5. Pitanja za ponavljanje, 10 zadatak:

podaci<-read.table("dijagram.txt",header=T,sep="\t")
y1<-podaci$y1
y2<-podaci$y2
y3<-podaci$y3
x<-podaci$x

par(mfrow = c(1, 1),mar=c(4,4,1,1))
plot(x,y1)
plot(x,y2)
plot(x,y3)

emf("Zadatak 10, lijevi panel.emf")
plot(x,y1)
dev.off()
emf("Zadatak 10, desni panel.emf")
plot(x,y2)
dev.off()
emf("Zadatak 10, donji panel.emf")
plot(x,y3)
dev.off()
#################################################################################
# POGLAVLJE 2
#################################################################################


#Primjer 2.1

#Slika 2.5. i 2.6.:

x<-c(10,15,12,7,4,14,22,1)
y<-c(18,29,21,11,7,25,44,1)

x_potez<-mean(x)
y_potez<-mean(y)

umnozak<-t(x)%*%(y)
x_potez_2<-mean(x)^2
x_2<-sum(x^2)

beta_1<-(umnozak-8*x_potez*y_potez)/(x_2-8*x_potez_2)
beta_0<-y_potez-beta_1*x_potez

beta_1;beta_0

#Slika 2.7. i Slika 2.8.:

plot(x,y)
abline(a=beta_0,b=beta_1)

emf("Slika 2.8. Dijagram rasipanja zajedno s regresijskim pravcem temeljem naredbi na slici 2.6.emf")
plot(x,y)
abline(a=beta_0,b=beta_1)
dev.off()

#Slika 2.9. i Slika 2.10.:

procjena<-beta_0[1,1]+beta_1[1,1]*x
rezidual<-y-procjena
procjena
rezidual

#################################################################################

#Primjer 2.2

#Slika 2.11.

x<-c(10,15,12,7,4,14,22,1)
y<-c(18,29,21,11,7,25,44,1)

y<-as.matrix(y)
jed<-c(rep(1,each=8))
jed<-as.matrix(jed)

x<-as.matrix(x)
X<-cbind(jed,x)

a<-t(X)%*%X
b<-solve(a)
c<-t(X)%*%y
beta<-b%*%c
beta

#Slika 2.13.

procjena<-X%*%beta
rezidual<-y-procjena
procjena
rezidual

#################################################################################

#Primjer 2.5.

#provesti naredbe od primjera 2.1. i 2.2. prvo!!

#Slike 2.16. i 2.17.

#svojstvo 1:
round(sum(rezidual),6)
#svojstvo 2:
mean(y)==beta_0+beta_1*mean(x)
#svojstvo 3:
mean(y);mean(procjena)

#Slike 2.18. i 2.19.

round(sum(rezidual),6)
mean(y); beta[1,]+beta[2,]*mean(x); mean(procjena)

#################################################################################

#2.1.4. Sveobuhvatan Primjer

#Slika 2.20

set.seed(1)
x<-seq(1,500,1)
epsilon<-rnorm(500,0,50)
y<-(2+0.5*x+epsilon)

#Slika 2.21.
par(mfrow = c(1, 1),mar=c(4,4,1,1))
plot(x,y)

emf("Slika 2.21. Dijagram rasipanja temeljem generiranih podataka na slici 2.19..emf")
par(mfrow = c(1, 1),mar=c(4,4,1,1))
plot(x,y)
dev.off()
#Slika 2.22.
lm(y~x)

#Slika 2.23.
procjena<-fitted(lm(y~x))

#Slika 2.24.
head(cbind(y,procjena,y-procjena))


#################################################################################

#2.1.5. Pitanja za ponavljanje

#Zadatak 15

y<-c(5,1,3,3.5,4.2)
x<-c(1,6,3,2,4)

plot(x,y)
lm(y~x)

emf("2.1.5. Pitanja za ponavljanje, Zadatak 15.emf")
plot(x,y)
lm(y~x)
dev.off()
#################################################################################

#Primjer 2.10.

#Slika 2.25. i 2.26. 

podaci<-read.table("BDP_i_HICP.txt",header=T, sep="\t")

m1<-lm(GDP~HICP,data=podaci)
m2<-lm(log(GDP)~log(HICP),data=podaci)
m3<-lm(log(GDP)~HICP,data=podaci)
m4<-lm(GDP~log(HICP),data=podaci)

m1$coefficients
m2$coefficients
m3$coefficients
m4$coefficients

#################################################################################

#Slika 2.27.
x<-seq(1,500,1)
epsilon<-rnorm(500,0,1)
y<-50+.1*x+epsilon*10

plot(x,y,col="grey",ylim=c(0,150))
abline(lm(y~x))
abline(lm(y~0+x),lty="dashed")

emf("Slika 2.27. Usporedba regresijskog pravca kroz ishodite (iscrtana linija) sa regresijskim pravcem uz konstantni lan (puna linija).emf")
plot(x,y,col="grey",ylim=c(0,150))
abline(lm(y~x))
abline(lm(y~0+x),lty="dashed")   
dev.off()
#################################################################################

#Primjer 2.12.

#Slika 2.28.

podaci<-read.table("BDP_i_HICP.txt",header=T, sep="\t")
lm(scale(GDP)~0+scale(HICP),data=podaci)


#################################################################################

#Primjer 2.13.

podaci<-read.table("BDP_i_HICP.txt",header=T, sep="\t")

m1<-lm(GDP~HICP,data=podaci)
m2<-lm(log(GDP)~log(HICP),data=podaci)
m3<-lm(log(GDP)~HICP,data=podaci)
m4<-lm(GDP~log(HICP),data=podaci)

#Slika 2.30. i 2.31.

confint(m1,level=0.95)
confint(m2,level=0.95)
confint(m3,level=0.95)
confint(m4,level=0.95)


#################################################################################

#Primjer 2.14.

podaci<-read.table("BDP_i_HICP.txt",header=T, sep="\t")

m1<-lm(GDP~HICP,data=podaci)
m2<-lm(log(GDP)~log(HICP),data=podaci)
m3<-lm(log(GDP)~HICP,data=podaci)
m4<-lm(GDP~log(HICP),data=podaci)

#Slika 2.32. lijevi panel:

confint(m1,level=0.9)
confint(m2,level=0.9)
confint(m3,level=0.9)
confint(m4,level=0.9)

#Slika 2.32. desni panel:

confint(m1,level=0.99)
confint(m2,level=0.99)
confint(m3,level=0.99)
confint(m4,level=0.99)


#################################################################################

#Primjer 2.15.

podaci<-read.table("BDP_i_HICP.txt",header=T, sep="\t")

#Slika 2.34.
m1<-lm(GDP~HICP,data=podaci)
summary(m1)

#Slika 2.35.
m1<-lm(GDP~HICP,data=podaci)

sazetak<-summary(m1)

sazetak$sigma
GDP<-podaci$GDP
koef_v<-(sazetak$sigma/mean(GDP))*100
koef_v

#Slika 2.36.

anova(m1)

#Slika 2.37.

HICP<-podaci$HICP
cor(HICP, GDP)


#################################################################################

#Primjer 2.17.

#Slika 2.40.

podaci<-read.table("BDP_i_HICP.txt",header=T, sep="\t")
m1<-lm(GDP~HICP,data=podaci)
summary(m1)

#Slika 2.41.

#kriticna granica za dvosmjerni test
kriticna<-abs(qt(0.05/2,32-2))
kriticna

#za jednosmjerni (na gornju granicu):
kriticna2<-qt(1-0.05,32-2)
kriticna2

#za jednosmjerni (na donju granicu):
kriticna2<-qt(0.05,32-2)
kriticna2

#Slika 2.42. lijevi panel:

#kriticna granica za dvosmjerni test
kriticna<-abs(qt(0.01/2,32-2))
kriticna

#za jednosmjerni (na gornju granicu):
kriticna2<-qt(0.01,32-2)
kriticna2

#Slika 2.42. desni panel:


#kriticna granica za dvosmjerni test
kriticna<-abs(qt(0.1/2,32-2))
kriticna

#za jednosmjerni (na gornju granicu):
kriticna2<-qt(0.1,32-2)
kriticna2


#################################################################################

#Primjer 2.18.

#Slika 2.44.
podaci<-read.table("BDP_i_HICP.txt",header=T, sep="\t")
m1<-lm(GDP~HICP,data=podaci)
summary(m1)

#Slika 2.45.

anova(m1)

#Slika 2.46.

#za F test:

qf(1-0.05,1,32-2)
qf(0.99,1,30); qf(0.9,1,30)



#################################################################################

#Primjer 2.19.

podaci<-read.table("BDP_i_HICP.txt",header=T, sep="\t")
m1<-lm(GDP~HICP,data=podaci)

#Slika 2.47.


#Waldov test
library(car)
ogranicenje<-"HICP=0"
linearHypothesis(m1,ogranicenje,test="Chisq")
qchisq(0.95,1)


#################################################################################

#Primjer 2.20.

#Slika 2.48.


podaci<-read.table("BDP_i_HICP.txt",header=T, sep="\t")
m1<-lm(GDP~HICP,data=podaci)

#LR test
library(lmtest)
m2<-lm(GDP~1,data=podaci)
lrtest(m1,m2)


#################################################################################

#Primjer 2.21.

1-pchisq(0.089664,1)



#################################################################################

#Primjer 2.22.


podaci<-read.table("BDP_i_HICP.txt",header=T, sep="\t")
m1<-lm(GDP~HICP,data=podaci)

#Slika 2.50.

#predvianje:
novo <- data.frame(HICP=120)
predict(m1, newdata = novo, interval = 'confidence',level = 0.95)


#################################################################################

#2.1.11. Sveobuhvatan Primjer

#Slika 2.51.

#ucitavanja podataka: read.table("naziv",zaglavlje da ili ne, separator)
podaci<-read.table("udio_65.txt",header=T, sep="\t")

#procjena modela OLS metodom: lm(zavisna~nezavisne var,izvor podataka)
model<-lm(health~Udio_65,data=podaci)
summary(model)

#Slika 2.52.

#provedba t-testa:
abs(qt(0.05/2,29))
qt(1-0.05,29)

#####
#napomena:
#kriticna granica t-testa:
#za jednosmjerni t-test: qt(alfa,ss)
#npr. za alfa 5% i ss = 40:
qt(0.05, 40)
#rezultat je za donju granicu
#za gornju granicu promatramo 5% u desnome repu 1-0.05 = 95%
qt(0.95,40)
#ili naprosto apsolutnu vrijednost:
abs(qt(0.05,40))
#za dvosmjerni t-test -> dijelimo alfu s vrijednou 2!
#npr. za alfa 5% i ss=40
qt(0.05/2,40)
#####


#Slika 2.53.

#koeficijent jednostavne linearne korelacije
sqrt(summary(model)$r.squared)

#procjena standardne pogre?ke regresije:
summary(model)$sigma

#procjena koeficijenta varijacije regresije:
potrosnja<-podaci$health
(summary(model)$sigma/mean(potrosnja))*100

#Slika 2.54.

#model sa standardiziranim varijablama:
lm(scale(health)~0+scale(Udio_65),data=podaci)

#Slika 2.55.

#F test i tablica ANOVA:
qf(1-0.05,1,29)
anova(model)

#Slika 2.56.

#intervalna procjena parametara:
confint(model,level=0.90)

#Slika 2.57. 

#Waldov test
library(car)
ogranicenje<-"Udio_65=0"
linearHypothesis(model,ogranicenje,test="Chisq")

#Slika 2.58.

#LR test
library(lmtest)
m2<-lm(health~1,data=podaci)
lrtest(model,m2)

#Slika 2.59.

#spajanje ispisa modela stargazer
model2<-lm(log(health)~Udio_65,data=podaci)
library(stargazer)
stargazer(list(model,model2),type="text")

#Slika 2.60.

#predvianje:
novo <- data.frame(Udio_65=0.2)
predict(model, newdata = novo, interval = 'confidence',level = 0.95)


#################################################################################

# 2.1.12. Pitanja za ponavljanje, zadatak 24:

#Phillips

#uitavanje podataka
podaci<-read.table("phillips.txt",header=T, sep="\t")

#procjena modela u a)
model<-lm(s_inflacije~s_nezaposlenosti,data=podaci)
summary(model)

#provedba t-testa
abs(qt(0.05/2,34-2))
qt(1-0.05,34-2)

#R, standardna pogreka regresije, koeficijent varijacije regresije
sqrt(summary(model)$r.squared)
summary(model)$sigma
s_inflacije<-podaci$s_inflacije
(summary(model)$sigma/mean(s_inflacije))*100

#standardizirane varijable u modelu:
lm(scale(s_inflacije)~0+scale(s_nezaposlenosti),data=podaci)

#F test i tablica ANOVA
qf(1-0.05,1,34-2)
anova(model)

#intervalna procjena parametara
confint(model,level=0.90)

#Wald test
library(car)
ogranicenje<-"s_nezaposlenosti=0"
linearHypothesis(model,ogranicenje,test="Chisq")

#LM test
library(lmtest)
m2<-lm(s_inflacije~1,data=podaci)
lrtest(model,m2)

#predvianje:
novo <- data.frame(s_nezaposlenosti=0.15)
predict(model, newdata = novo, interval = 'confidence',level = 0.95)


#################################################################################

# 2.1.12. Pitanja za ponavljanje, zadatak 25:

# reciprocna veza - iste naredbe osim pocetni model:

plot(podaci$s_nezaposlenosti,podaci$s_inflacije)
emf("2.1.12. Pitanja za ponavljanje, zadatak 25.emf")
plot(podaci$s_nezaposlenosti,podaci$s_inflacije)
dev.off()

model<-lm(s_inflacije~I(1/s_nezaposlenosti),data=podaci)
summary(model)
abs(qt(0.05/2,34-2))
qt(1-0.05,34-2)

sqrt(summary(model)$r.squared)
summary(model)$sigma
s_inflacije<-podaci$s_inflacije
(summary(model)$sigma/mean(s_inflacije))*100

lm(scale(s_inflacije)~0+scale(I(1/s_nezaposlenosti)),data=podaci)

qf(1-0.05,1,34-2)
anova(model)

confint(model,level=0.90)

library(car)
ogranicenje<-"I(1/s_nezaposlenosti)=0"
linearHypothesis(model,ogranicenje,test="Chisq")

library(lmtest)
m2<-lm(s_inflacije~1,data=podaci)
lrtest(model,m2)

#predvianje:
novo <- data.frame(s_nezaposlenosti=0.15)
predict(model, newdata = novo, interval = 'confidence',level = 0.95)



#################################################################################

# 2.1.12. Pitanja za ponavljanje, zadatak 26:

#usporedba modela iz 1 i 2:
m1<-lm(s_inflacije~s_nezaposlenosti,data=podaci)
m2<-lm(s_inflacije~I(1/s_nezaposlenosti),data=podaci)
library(stargazer)
stargazer(list(m1,m2),type="text")



#################################################################################

#Primjer 2.23.

#Slika 2.61. i slika 2.62.

y<-c(18,29,21,11,7,25,44,1)
x1<-c(10,15,12,7,4,14,22,1)
x2<-c(13,12,16,8,10,11,25,5)
x3<-c(9,3,7,14,18,2,1,22)
y<-as.matrix(y)
jed<-c(rep(1,each=8))
jed<-as.matrix(jed)

x<-as.matrix(cbind(x1,x2,x3))
X<-cbind(jed,x)

a<-t(X)%*%X
b<-solve(a)
c<-t(X)%*%y
beta<-b%*%c
beta


#################################################################################

#Primjer 2.24.

#Slika 2.63.

#prvo provesti primjer 2.23.!

summary(lm(y~x1+x2+x3))

#################################################################################

#Primjer 2.29.

#prvo provesti primjer 2.23.!

#Slika 2.64.

lm(scale(y)~0+scale(x1)+scale(x2)+scale(x3))


#################################################################################

#Primjer 2.31.

#prvo provesti primjer 2.23.!

#Slika 2.65.
model<-lm(y~x1+x2+x3)
confint(model,level=0.92)


#################################################################################

#Primjer 2.32.


#prvo provesti primjer 2.23.!

#Slika 2.66.

summary(lm(y~x1+x2+x3))

#slika 2.67.

model<-lm(y~x1+x2+x3)
sazetak<-summary(model)

sazetak$sigma
sazetak$sigma/mean(y)

#Slika 2.68.


model2<-lm(y~1)
anova(model,model2)



#################################################################################

#Primjer 2.33.

#kriticne granice za provodenje testova:

abs(qt(0.05/2,4))
abs(qt(0.05,4))
qf(1-0.05,3,4)


#################################################################################

#Primjer 2.34.

#kriticne granice za provodenje testova:
qf(0.99,3,4) ; qf(0.9,3,4)



#################################################################################

#Primjer 2.36.

y<-c(18,29,21,11,7,25,44,1)
x1<-c(10,15,12,7,4,14,22,1)
x2<-c(13,12,16,8,10,11,25,5)
x3<-c(9,3,7,14,18,2,1,22)
y<-as.matrix(y)
jed<-c(rep(1,each=8))
jed<-as.matrix(jed)

x<-as.matrix(cbind(x1,x2,x3))
X<-cbind(jed,x)

model<-lm(y~x1+x2+x3)

#Slika 2.69.

library(car)
ogranicenje<-"x2=0"
linearHypothesis(model,ogranicenje,test="Chisq")

#Slika 2.70.

library(car)
ogranicenje<-c("x1=0","x3=0")
linearHypothesis(model,ogranicenje,test="Chisq")

#Slika 2.71.

library(car)
ogranicenje<-c("x3=0.5")
linearHypothesis(model,ogranicenje,test="Chisq")


#################################################################################

#Primjer 2.37.

y<-c(18,29,21,11,7,25,44,1)
x1<-c(10,15,12,7,4,14,22,1)
x2<-c(13,12,16,8,10,11,25,5)
x3<-c(9,3,7,14,18,2,1,22)


model<-lm(y~x1+x2+x3)

#Slika 2.72.

library(car)
#F test
ogranicenje<-"x2=0"
linearHypothesis(model,ogranicenje,test="F")

#Slika 2.73.

library(car)
ogranicenje<-c("x1=0","x3=0")
linearHypothesis(model,ogranicenje,test="F")

#Slika 2.74.

library(car)
ogranicenje<-c("x3=0.5")
linearHypothesis(model,ogranicenje,test="F")


#################################################################################

#Primjer 2.38.

y<-c(18,29,21,11,7,25,44,1)
x1<-c(10,15,12,7,4,14,22,1)
x2<-c(13,12,16,8,10,11,25,5)
x3<-c(9,3,7,14,18,2,1,22)

model1<-lm(y~x1+x2+x3)
ssr_1<-sum(resid(model1)^2)
model2<-lm(y~x2+x3)
ssr_2<-sum(resid(model2)^2)
ssr_1;ssr_2
emp<-((ssr_2-ssr_1)/1)/(ssr_1/(8-2-1-1))
emp


#Slika 2.75.

#Izostavljena znaajna regresijska varijabla

1-pf(emp,1,8-2-1-1)


#Slika 2.76.

library(lmtest)
model2<-lm(y~x2+x3)
lrtest(model1,model2)

#Slika 2.77.

model
model2


#################################################################################

#Primjer 2.40.

y<-c(18,29,21,11,7,25,44,1)
x1<-c(10,15,12,7,4,14,22,1)
x2<-c(13,12,16,8,10,11,25,5)
x3<-c(9,3,7,14,18,2,1,22)

#Slika 2.78.

model<-lm(y~x1+x2+x3)
library(car)
ogranicenje<-"x1=0"
linearHypothesis(model,ogranicenje,test="F")

qf(1-0.05,1,4)



#################################################################################

#Primjer 2.41.


y<-c(18,29,21,11,7,25,44,1)
x1<-c(10,15,12,7,4,14,22,1)
x2<-c(13,12,16,8,10,11,25,5)
x3<-c(9,3,7,14,18,2,1,22)

#Slika 2.79.

#stabilnost parametara
y1<-y[1:4];x11<-x1[1:4]
y2<-y[5:8];x12<-x1[5:8]
library(gap)
chow.test(y1,x11,y2,x12)


#Slika 2.80. lijevi panel

summary(lm(y1~x11))

#Slika 2.80. desni panel

summary(lm(y2~x12))


#Slika 2.81.
sum(resid(lm(y1~x11))^2)
sum(resid(lm(y2~x12))^2)
sum(resid(lm(y~x1))^2)

#################################################################################

#Primjer 2.42.

y<-c(18,29,21,11,7,25,44,1)
x1<-c(10,15,12,7,4,14,22,1)
x2<-c(13,12,16,8,10,11,25,5)
x3<-c(9,3,7,14,18,2,1,22)

#Slika 2.83.

model<-lm(y~x1+x2+x3)
library(lmtest)
resettest(model,power=2:3,type="fitted")


#Slika 2.84.

model<-lm(y~x1+x2+x3)
y1<-fitted(model)
model_novo<-lm(y~x1+x2+x3+I(y1^2)+I(y1^3))
library(car)
ogranicenje<-c("I(y1^2)=0","I(y1^3)=0")
linearHypothesis(model_novo,ogranicenje,test="F")



#################################################################################

#Primjer 2.43.

y<-c(18,29,21,11,7,25,44,1,0,43,24,6,10,20,28,17)
x1<-c(10,15,12,7,4,14,22,1,0,21,13,3,6,11,14,9)
x2<-c(13,12,16,8,10,11,25,5,4,24,10,9,7,15,11,12)
x3<-c(9,3,7,14,18,2,1,22,21,0,1,17,13,6,2,8)

#Slika  2.85. i Slika 2.86.

library(strucchange)
y<-ts(y,start=1,frequency = 1)
x1<-ts(x1,start=1,frequency = 1)
x2<-ts(x2,start=1,frequency = 1)
x3<-ts(x3,start=1,frequency = 1)
cusum <- efp(y~x1+x2+x3, type = "OLS-CUSUM")
plot(cusum,xlab=NA)

emf("Slika 2.86. CUSUM test predoen grafiki.emf")
plot(cusum,xlab=NA)
dev.off()

fs <- Fstats(y~x1+x2+x3, from = 10, to = 11)
sctest(fs, type="aveF")


#################################################################################

#Primjer 2.44.

y<-c(18,29,21,11,7,25,44,1)
x1<-c(10,15,12,7,4,14,22,1)
x2<-c(13,12,16,8,10,11,25,5)
x3<-c(9,3,7,14,18,2,1,22)

model<-lm(y~x1+x2+x3)


#Slika 2.87.

novo<-data.frame(x1=10,x2=5,x3=10)
predict(model,newdata = novo,interval = "confidence",level=.95)


#################################################################################


# 2.2.9. Sveobuhvatan Primjer


#Slika 2.88.

potrosnja<-read.table("potrosnja.txt",header=T,sep="\t")

m1<-lm(potrosnja~bdp+cijene,data=potrosnja)
m2<-lm(log(potrosnja)~log(bdp)+log(cijene),data=potrosnja)
m3<-lm(scale(potrosnja)~0+scale(bdp)+scale(cijene),data=potrosnja)

#Slika 2.89.

library(stargazer)
stargazer(list(m1,m2,m3),type="text")

#Slika 2.90.
summary(m1)


#Slika 2.91.
cbind(qt(0.95,137), qf(0.95,2,137))

#Slika 2.92.

m4<-lm(log(potrosnja)~bdp+cijene,data=potrosnja)
m5<-lm(potrosnja~log(bdp)+log(cijene),data=potrosnja)

stargazer(list(m1,m2,m4,m5),type="text")

#Slika 2.93.
confint(m1,level=.9)

#Slika 2.94.
y<-potrosnja$potrosnja
sazetak<-summary(m1)
cbind(sazetak$sigma,sazetak$sigma/mean(y))

#Slika 2.95.

library(car)
ogranicenje<-"bdp=2*cijene"
linearHypothesis(m1,ogranicenje,test="Chisq")


#Slika 2.96.

library(car)
ogranicenje<-c("bdp=.7","cijene=0")
linearHypothesis(m1,ogranicenje,test="Chisq")


#Slika 2.97.

library(car)
ogranicenje<-"bdp=2*cijene"
linearHypothesis(m1,ogranicenje,test="F")


#Slika 2.98.

library(car)
ogranicenje<-c("bdp=.7","cijene=0")
linearHypothesis(m1,ogranicenje,test="F")


#Slika 2.99.

library(car)
ogranicenje<-c("bdp=0")
linearHypothesis(m1,ogranicenje,test="F")

#Slika 2.100.

library(lmtest)
model2<-lm(potrosnja~bdp,data=potrosnja)
lrtest(m1,model2)
View(lrtest(m1,model2))


#Slika 2.101.
y<-potrosnja$potrosnja


bdp<-potrosnja$bdp;cijene<-potrosnja$cijene
y1<-y[1:70];bdp1<-bdp[1:70];cijene1<-cijene[1:70]
y2<-y[71:140];bdp2<-bdp[71:140];cijene2<-cijene[71:140]
library(gap)
chow.test(y1,c(bdp1,cijene1),y2,c(bdp2,cijene2))


#Slika 2.102.

library(lmtest)
resettest(m1,power=2:3,type="fitted")


#Slika 2.103.

summary(lm(potrosnja~bdp+cijene+I(fitted(m1)^2)+I(fitted(m1)^3),data=potrosnja))

#Slika 2.104.

novo<-data.frame(bdp=1000,cijene=134)
predict(m1,newdata = novo,interval = "confidence",level=.90)

#################################################################################


# 2.2.10. Pitanja za ponavljanje, zadatak 27:

place<-read.table("placa.txt",header=T,sep="\t")

m1<-lm(placa~staz+obrazovanje,data=place)
m2<-lm(log(placa)~log(staz)+log(obrazovanje),data=place)
m3<-lm(scale(placa)~0+scale(staz)+scale(obrazovanje),data=place)

library(stargazer)
stargazer(list(m1,m2,m3),type="text")
m4<-lm(log(placa)~staz+obrazovanje,data=place)
m5<-lm(placa~log(staz)+log(obrazovanje),data=place)

stargazer(list(m1,m2,m4,m5),type="text")

confint(m1,level=.9)


summary(m1)
cbind(qt(0.95,147), qf(0.95,2,147))


y<-place$placa
sazetak<-summary(m1)
cbind(sazetak$sigma,sazetak$sigma/mean(y))


library(car)
ogranicenje<-"staz=500+obrazovanje"
linearHypothesis(m1,ogranicenje,test="Chisq")
ogranicenje<-"staz=obrazovanje"
linearHypothesis(m1,ogranicenje,test="Chisq")
ogranicenje<-"staz=500+obrazovanje"
linearHypothesis(m1,ogranicenje,test="F")
ogranicenje<-"staz=obrazovanje"
linearHypothesis(m1,ogranicenje,test="F")


ogranicenje<-c("obrazovanje=0")
linearHypothesis(m1,ogranicenje,test="F")


library(lmtest)
model2<-lm(placa~obrazovanje,data=place)
lrtest(m1,model2)


placa<-place$placa;staz<-place$staz;obraz<-place$obrazovanje
placa1<-y[1:75];staz1<-staz[1:75];obraz1<-obraz[1:75]
placa2<-y[76:150];staz2<-staz[76:150];obraz2<-obraz[76:150]
library(gap)
chow.test(placa,c(obraz1,staz1),placa2,c(obraz2,staz2))

library(lmtest)
resettest(m1,power=2:4,type="fitted")

library(strucchange)
placa<-ts(place$placa,start=1,frequency = 1)
staz<-ts(place$staz,start=1,frequency = 1)
obrazovanje<-ts(place$obrazovanje,start=1,frequency = 1)

cusum <- efp(placa~staz+obrazovanje, type = "OLS-CUSUM")
plot(cusum,xlab=NA)
fs <- Fstats(placa~staz+obrazovanje, from = 80, to = 120)
sctest(fs, type="aveF")

emf("2.2.10. Pitanja za ponavljanje, OLS-based CUSUM test, zadatak 27.emf")
plot(cusum,xlab=NA)
dev.off()

novo<-data.frame(staz=19,obrazovanje=15)
predict(m1,newdata = novo,interval = "confidence",level=.99)



#################################################################################
# POGLAVLJE 3
#################################################################################

#Primjer 3.1.

#Slika 3.2.

bin<-read.table("binarne.txt",header=T,sep="\t")
binarna<-ifelse(bin$spol=="m",1,0)
summary(lm(placa~binarna,data=bin))

#################################################################################

#Primjer 3.2.

bin<-read.table("binarne.txt",header=T,sep="\t")
binarna<-ifelse(bin$spol=="m",1,0)

#Slika 3.3.

summary(lm(placa~binarna+staz+obrazovanje,data=bin))


#################################################################################

#Primjer 3.3.

bin<-read.table("binarne.txt",header=T,sep="\t")
binarna<-ifelse(bin$spol=="m",1,0)

#Slika 3.4.

summary(lm(placa~staz+obrazovanje+I(staz*binarna)+I(obrazovanje*binarna),data=bin))


#################################################################################

#Primjer 3.4.


bin<-read.table("binarne.txt",header=T,sep="\t")
binarna<-ifelse(bin$spol=="m",1,0)

#Slika 3.5.

bin1<-ifelse(bin$staz>=15,1,0)
bin2<-ifelse(bin$obrazovanje>=12,1,0)

summary(lm(placa~bin1*bin2,data=bin))



#################################################################################

#Primjer 3.5.

#Slika 3.6.

cd<-read.table("cobb-douglas.txt",sep="\t",header=T)
summary(lm(log(proizvodnja)~log(rad)+log(kapital),data=cd))

#Slika 3.7.


model<-lm(log(proizvodnja)~log(rad)+log(kapital),data=cd)
library(car)
ogranicenje<-"log(rad)+log(kapital)=1"
linearHypothesis(model,ogranicenje,test="Chisq")



#################################################################################

# 3.3. Pitanja za ponavljanje, zadatak 6:

potrosnja<-read.table("potrosnja.txt",header=T,sep="\t")

bin<-ifelse(potrosnja$cijene>=125,1,0)

m1<-lm(potrosnja~bdp+bin,data=potrosnja)
m2<-lm(potrosnja~bdp+I(bin*bdp),data=potrosnja)
m3<-lm(potrosnja~bin,data=potrosnja)

library(stargazer)
stargazer(list(m1,m2,m3),type="text")


bin2<-ifelse(potrosnja$bdp>=1500,1,0)

m4<-lm(potrosnja~bin+bin2,data=potrosnja)
m5<-lm(potrosnja~bin*bin2,data=potrosnja)

stargazer(list(m4,m5),type="text")




#################################################################################
# POGLAVLJE 4
#################################################################################


# 4.1.4. Primjer

#Slika 4.1.

stanovi<-read.table("stanovi.txt",sep="\t",header=T)
model<-lm(cijena~kvadrat+sobe+godine+udaljenost,data=stanovi)

library(car)
vif(model)
1/vif(model)

#Slika 4.2.


m1<-lm(kvadrat~sobe+godine+udaljenost,data=stanovi)
m2<-lm(sobe~kvadrat+godine+udaljenost,data=stanovi)
summary(m1)$r.squared
summary(m2)$r.squared

#Slika 4.3.

cor(stanovi)
sqrt(summary(model)$r.squared)

#Slika 4.4.

summary(model)


#Slika 4.5.

m2<-lm(cijena~sobe+godine+udaljenost,data=stanovi)
m3<-lm(cijena~kvadrat+godine+udaljenost,data=stanovi)
library(stargazer)
stargazer(list(m2,m3),type="text")


#Slika 4.6.

eps<-seq(1:100)
eps<-eps+10*rnorm(100,1,1)

eps_1<-c(NA,eps[1:99])

par(mfrow = c(1,1),oma=c(1,0,0,1),mar=c(4,4,1,1))

plot(eps_1,eps,xlab="y(t-1)",ylab="y(t)")
emf("Slika 4.6. Pozitivna autokorelacija prvog reda.emf")
plot(eps_1,eps,xlab="y(t-1)",ylab="y(t)")
dev.off()

#Slika 4.7.

eps2<-seq(1:100)
eps2<-(-eps2-10*rnorm(100,1,1))
eps2_1<-c(NA,eps[1:99])
plot(eps2_1,eps2,xlab="y(t-1)",ylab="y(t)")

emf("Slika 4.7. Negativna autokorelacija prvog reda.emf")
plot(eps2_1,eps2,xlab="y(t-1)",ylab="y(t)")
dev.off()

#Slika 4.8.

eps3<-rnorm(100,0,1)
eps3_1<-c(NA,eps3[1:99])
plot(eps3_1,eps3,xlab="y(t-1)",ylab="y(t)")



#################################################################################


# 4.2.4. Primjer


stanovi<-read.table("stanovi.txt",sep="\t",header=T)
model<-lm(cijena~kvadrat+sobe+godine+udaljenost,data=stanovi)
emf("Slika 4.8. Nepostojanje autokorelacija prvog reda.emf")
plot(eps3_1,eps3,xlab="y(t-1)",ylab="y(t)")
dev.off()

#Slika 4.10.

library(car)
durbinWatsonTest(model)
durbinWatsonTest(model,alternative = "positive")
durbinWatsonTest(model,alternative = "negative")

#Slika 4.11.

library(quantmod)
reziduali<-residuals(model)
rez1<-Lag(reziduali,1);rez2<-Lag(reziduali,2);rez3<-Lag(reziduali,3)
summary(pomocna<-lm(reziduali~kvadrat+sobe+godine+udaljenost+rez1+rez2+rez3,data=stanovi))



#ako ne radi Lag:
length(reziduali)
rez1<-c(NA,reziduali[1:49])
rez2<-c(NA,rez1[1:49])
rez3<-c(NA,rez2[1:49])
summary(pomocna<-lm(reziduali~kvadrat+sobe+godine+udaljenost+rez1+rez2+rez3,data=stanovi))


#Slika 4.12.

test_vel<-nobs(pomocna)*summary(pomocna)$r.squared
test_vel
p_v<-1-pchisq(test_vel,3)
p_v

#Slika 4.13.
Box.test(reziduali,lag=3,type="Ljung-Box")

#################################################################################

#slika 4.15

procijenjen_y<-rnorm(1000,5,1)
res2<-procijenjen_y

for (i in 1:1000)
{
  res2[i]<-procijenjen_y[i]*(i^2)/10000+2
}

plot(procijenjen_y,res2,xlab="Procijenjen y",ylab="Kvadrat reziduala")
#################################################################################


# 4.3.4. Primjer


stanovi<-read.table("stanovi.txt",sep="\t",header=T)
model<-lm(cijena~kvadrat+sobe+godine+udaljenost,data=stanovi)

#Slika 4.16.

summary(bptest<-lm(residuals(model)^2~kvadrat+sobe+godine+udaljenost,data=stanovi))
nobs(bptest);(summary(bptest))$r.squared
nobs(bptest)*(summary(bptest))$r.squared

p_vrijednost<-1-pchisq(nobs(bptest)*(summary(bptest))$r.squared,4)
p_vrijednost

#Slika 4.17.

summary(white<-lm(residuals(model)^2~
                    kvadrat+sobe+godine+udaljenost
                  +I(kvadrat^2)+I(sobe^2)+I(godine^2)+I(udaljenost^2)
                  +I(kvadrat*sobe)+I(kvadrat*godine)+I(kvadrat*udaljenost)
                  +I(sobe*godine)+I(sobe*udaljenost)+I(godine*udaljenost)
                  ,data=stanovi))

nobs(white);(summary(white))$r.squared
nobs(white)*(summary(white))$r.squared

p_vrijednost<-1-pchisq(nobs(white)*(summary(white))$r.squared,14)
p_vrijednost

#Slika 4.18.


#White korekcija:
library(car)
mat<-hccm(model,type="hc0")
mat #ovo je matrica var-kovar procjenitelja uz White korekciju
#t-test :
library(lmtest)
coeftest(model,vcov=mat)

#Slika 4.19.


#Newey-West korekcija:
library(sandwich)
mat2<-NeweyWest(model,lag=2)
mat2 #ovo je matrica var-kovar procjenitelja uz Newey-West korekciju
#t-test :
library(lmtest)
coeftest(model,vcov=mat2)

#################################################################################


#Slika 4.20.
stanovi<-read.table("stanovi.txt",sep="\t",header=T)

par(mfrow = c(1,1),oma=c(1,0,0,1),mar=c(4,4,1,1))
hist(stanovi$cijena,main=NA,xlab="cijena",ylab="frekvencija",probability = T)
curve(dnorm(x,mean(stanovi$cijena),sd(stanovi$cijena)),
      lwd=2, add=TRUE, yaxt="n")

emf("Slika 4.20. Usporedba histograma s normalnom distribucijom, cijena m2 stana.emf")
par(mfrow = c(1,1),oma=c(1,0,0,1),mar=c(4,4,1,1))
hist(stanovi$cijena,main=NA,xlab="cijena",ylab="frekvencija",probability = T)
curve(dnorm(x,mean(stanovi$cijena),sd(stanovi$cijena)),
      lwd=2, add=TRUE, yaxt="n")
dev.off()

#Slika 4.21.
model<-lm(cijena~kvadrat+sobe+godine+udaljenost,data=stanovi)
rezidual<-resid(model)
hist(rezidual,main=NA,xlab="rezidual",ylab="frekvencija",probability = T,ylim=c(0,.07))
curve(dnorm(x,mean(rezidual),sd(rezidual)),
      lwd=2, add=TRUE, yaxt="n")

emf("Slika 4.21. Usporedba histograma s normalnom distribucijom, rezidualna odstupanja regresijskog modela.emf")
hist(rezidual,main=NA,xlab="rezidual",ylab="frekvencija",probability = T)
curve(dnorm(x,mean(rezidual),sd(rezidual)),
      lwd=2, add=TRUE, yaxt="n")
dev.off()

#Slika 4.22.
qqnorm(rezidual, pch = 1, frame = T,main=NA,xlab="teorijski",ylab="rezidual")
qqline(rezidual, col = "black", lwd = 1)

emf("Slika 4.22. Dijagram vjerojatnosti rezidualnih odstupanja regresijskog modela.emf")
qqnorm(rezidual, pch = 1, frame = T,main=NA,xlab="teorijski",ylab="rezidual")
qqline(rezidual, col = "black", lwd = 1)
dev.off()
#################################################################################


# 4.4.4. primjer

stanovi<-read.table("stanovi.txt",sep="\t",header=T)
model<-lm(cijena~kvadrat+sobe+godine+udaljenost,data=stanovi)

#Slika 4.23.


#Jarque-Bera test:
reziduali<-resid(model)
library("moments")
jarque.test(reziduali)

#N, koef. asimetrije i zaobljenosti:
n<-length(reziduali); s<-skewness(reziduali); k<-kurtosis(reziduali)
n;s;k
JB<-n*(s^2/6+(k-3)^2/24)
JB

#Slika 4.24.

library(nortest)
ad.test(reziduali)
cvm.test(reziduali)
lillie.test(reziduali)

#################################################################################


# Primjer 4.1.

stanovi<-read.table("stanovi.txt",sep="\t",header=T)
model<-lm(cijena~kvadrat+sobe+godine+udaljenost,data=stanovi)

#Slika 4.25.

OLS<-lm(cijena~kvadrat+sobe+godine+udaljenost,data=stanovi)
library(nlme)
GLS<-gls(cijena~kvadrat+sobe+godine+udaljenost,
         data=stanovi,weights=varExp())
#usporedba procjena OLS i GLS metodom:
summary(OLS)$coefficients
summary(GLS)$tTable

#sad je funkcija gls(model,izvor podataka, teine koje se dodijele matrici kojom
#se korigira procjena parametara modela 

#teine mogu biti razliite:
#varExp exponential of a variance covariate.
#varPower power of a variance covariate.
#varConstPower constant plus power of a variance covariate.
#varIdent constant variance(s), generally used to allow different variances according to the
#levels of a classification factor.
#varFixed fixed weights, determined by a variance covariate.
#varComb combination of variance functions.


#################################################################################


# Primjer 4.1.

stanovi<-read.table("stanovi.txt",sep="\t",header=T)
model<-lm(cijena~kvadrat+sobe+godine+udaljenost,data=stanovi)

#Slika 4.26.
OLS<-lm(cijena~kvadrat+sobe+godine+udaljenost,data=stanovi)
#WLS:
WLS<-lm(cijena~kvadrat+sobe+godine+udaljenost,data=stanovi,weights=1/sobe)
summary(OLS)$coefficients
summary(WLS)$coefficients


#################################################################################


# 4.6. Primjer

#Slika 4.27.

cd<-read.table("cobb-douglas.txt",sep="\t",header=T)

#multikolinearnost
model<-lm(log(proizvodnja)~log(rad)+log(kapital),data=cd)

library(car)
vif(model)
1/vif(model)

m2<-lm(log(rad)~log(kapital),data=cd)
summary(m2)$r.squared

cor(cd)
sqrt(summary(model)$r.squared)

#Slika 4.28.

library(car)
durbinWatsonTest(model)
durbinWatsonTest(model,alternative = "positive")
durbinWatsonTest(model,alternative = "negative")

#Slika 4.29.

library(quantmod)
reziduali<-residuals(model)
rez1<-Lag(reziduali,1);rez2<-Lag(reziduali,2)
summary(pomocna<-lm(reziduali~log(rad)+log(kapital)+rez1+rez2,data=cd))
test_vel<-nobs(pomocna)*summary(pomocna)$r.squared
test_vel
p_v<-1-pchisq(test_vel,2)
p_v

#Slika 4.30.

Box.test(reziduali,lag=2,type="Ljung-Box")

#Slika 4.31.

summary(bptest<-lm(residuals(model)^2~log(rad)+log(kapital),data=cd))
nobs(bptest);(summary(bptest))$r.squared
nobs(bptest)*(summary(bptest))$r.squared

p_vrijednost<-1-pchisq(nobs(bptest)*(summary(bptest))$r.squared,2)
p_vrijednost

#Slika 4.32.

summary(white<-lm(residuals(model)^2~log(rad)+log(kapital)
                  +I(log(rad)*log(kapital))
                  +I(log(rad)^2)+I(log(kapital)^2),data=cd))

nobs(white);(summary(white))$r.squared
nobs(white)*(summary(white))$r.squared

p_vrijednost<-1-pchisq(nobs(white)*(summary(white))$r.squared,5)
p_vrijednost

# Slika 4.33.

OLS<-lm(log(proizvodnja)~log(rad)+log(kapital),data=cd)
summary(OLS)$coefficients


#White korekcija:
library(car)
mat<-hccm(model,type="hc0")
#t-test :
library(lmtest)
coeftest(model,vcov=mat)


#Newey-West korekcija:
library(sandwich)
mat2<-NeweyWest(model,lag=2)
#t-test :
library(lmtest)
coeftest(model,vcov=mat2)


# Slika 4.34.

reziduali<-resid(model)
library("moments")
jarque.test(reziduali)

#N, koef. asimetrije i zaobljenosti:
n<-length(reziduali); s<-skewness(reziduali); k<-kurtosis(reziduali)
n;s;k
JB<-n*(s^2/6+(k-3)^2/24)
JB


#
library(nortest)
ad.test(reziduali)
cvm.test(reziduali)
lillie.test(reziduali)

# Slika 4.35.

GLS<-gls(log(proizvodnja)~log(rad)+log(kapital),data=cd,weights=varExp())

summary(OLS)$coefficients
summary(GLS)$tTable


# Slika 4.36.


WLS<-lm(log(proizvodnja)~log(rad)+log(kapital),data=cd,weights=1/log(rad))
summary(OLS)$coefficients
summary(WLS)$coefficients



#################################################################################


# 4.7. Pitanja za ponavljanje, zadatak 37:

place<-read.table("placa.txt",header=T,sep="\t")

#multikolinearnost
model<-lm(placa~staz+obrazovanje,data=place)

library(car)
vif(model)
1/vif(model)

m1<-lm(staz~obrazovanje,data=place)
summary(m1)$r.squared

cor(place)
sqrt(summary(model)$r.squared)


#durbin watson
library(car)
durbinWatsonTest(model)
durbinWatsonTest(model,alternative = "positive")
durbinWatsonTest(model,alternative = "negative")

#breusch-godfrey
library(quantmod)
reziduali<-residuals(model)
rez1<-Lag(reziduali,1);rez2<-Lag(reziduali,2);rez3<-Lag(reziduali,3)
summary(pomocna<-lm(reziduali~staz+obrazovanje+rez1+rez2+rez3,data=place))
test_vel<-nobs(pomocna)*summary(pomocna)$r.squared
test_vel
p_v<-1-pchisq(test_vel,3)
p_v

#ako ne radi Lag:
length(reziduali)
rez1<-c(NA,reziduali[1:149])
rez2<-c(NA,rez1[1:149])
rez3<-c(NA,rez2[1:149])

#ljung-box
Box.test(reziduali,lag=3,type="Ljung-Box")

#heteroskedasti?nost:

#BG test:
summary(bptest<-lm(residuals(model)^2~staz+obrazovanje,data=place))
nobs(bptest);(summary(bptest))$r.squared
nobs(bptest)*(summary(bptest))$r.squared

p_vrijednost<-1-pchisq(nobs(bptest)*(summary(bptest))$r.squared,2)
p_vrijednost

#White test:
summary(white<-lm(residuals(model)^2~staz+obrazovanje
                  +I(staz*obrazovanje)
                  +I(staz^2)+I(obrazovanje^2),data=place))

nobs(white);(summary(white))$r.squared
nobs(white)*(summary(white))$r.squared

p_vrijednost<-1-pchisq(nobs(white)*(summary(white))$r.squared,5)
p_vrijednost

#korekcije

#White korekcija:
library(car)
mat<-hccm(model,type="hc0")
mat #ovo je matrica var-kovar procjenitelja uz White korekciju
#t-test :
library(lmtest)
coeftest(model,vcov=mat)


#Newey-West korekcija:
library(sandwich)
mat2<-NeweyWest(model,lag=3)
mat2 #ovo je matrica var-kovar procjenitelja uz Newey-West korekciju
#t-test :
library(lmtest)
coeftest(model,vcov=mat2)

#Normalnost:

#Jarque-Bera test:
reziduali<-resid(model)
library("moments")
jarque.test(reziduali)

#N, koef. asimetrije i zaobljenosti:
n<-length(reziduali); s<-skewness(reziduali); k<-kurtosis(reziduali)
n;s;k
JB<-n*(s^2/6+(k-3)^2/24)
JB

#
library(nortest)
ad.test(reziduali)
cvm.test(reziduali)
lillie.test(reziduali)

OLS<-lm(placa~staz+obrazovanje,data=place)
library(nlme)
GLS<-gls(placa~staz+obrazovanje,data=place,weights=varExp())
summary(OLS)$coefficients
summary(GLS)$tTable

WLS<-lm(placa~staz+obrazovanje,data=place,weights=1/obrazovanje)
summary(OLS)$coefficients
summary(WLS)$coefficients
